/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.audiodevice;

import de.maxhenkel.voicechat.configbuilder.entry.ConfigEntry;
import de.maxhenkel.voicechat.gui.audiodevice.AudioDeviceEntry;
import de.maxhenkel.voicechat.gui.widgets.ListScreenListBase;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.SoundManager;
import java.util.Collection;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;

public class AudioDeviceList
extends ListScreenListBase<AudioDeviceEntry> {
    public static final int CELL_HEIGHT = 36;
    @Nullable
    protected ResourceLocation icon;
    @Nullable
    protected Component defaultDeviceText;
    @Nullable
    protected ConfigEntry<String> configEntry;

    public AudioDeviceList(int width, int height, int top) {
        super(width, height, top, 36);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        AudioDeviceEntry entry = (AudioDeviceEntry)this.getEntryAtPosition(mouseX, mouseY);
        if (entry == null) {
            return false;
        }
        if (!this.isHovered()) {
            return false;
        }
        if (!this.isSelected(entry.getDevice())) {
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            this.onSelect(entry);
            return true;
        }
        return false;
    }

    protected void onSelect(AudioDeviceEntry entry) {
        ClientVoicechat client;
        if (this.configEntry != null) {
            this.configEntry.set(entry.device).save();
        }
        if ((client = ClientManager.getClient()) != null) {
            client.reloadAudio();
        }
    }

    public void replaceEntries(Collection<AudioDeviceEntry> entries) {
        super.replaceEntries(entries);
    }

    public void setAudioDevices(Collection<String> entries) {
        this.replaceEntries(Stream.concat(Stream.of(""), entries.stream()).map(s -> new AudioDeviceEntry((String)s, this.getVisibleName((String)s), this.icon, () -> this.isSelected((String)s))).toList());
    }

    public boolean isSelected(String name) {
        if (this.configEntry == null) {
            return false;
        }
        return this.configEntry.get().equals(name);
    }

    public Component getVisibleName(String device) {
        if (device.isEmpty() && this.defaultDeviceText != null) {
            return this.defaultDeviceText;
        }
        return Component.literal((String)SoundManager.cleanDeviceName(device));
    }

    public boolean isEmpty() {
        return this.children().isEmpty();
    }
}

